'==========================================================================
'
' Author......: Raffaele Chiatto
'
' WebSite.....: http://www.raffaelechiatto.com
'
' E-Mail......: raffaele.chiatto@gmail.com
'
'==========================================================================

Option Explicit

Dim isnew
Dim path, newpath, parent
Dim Text, Text1, Title, oFolder
Dim fso, oFolders, oSubFolder, wsh         ' Object variables

Text = "Folders" & vbCrLf & vbCrLf
Title = "Raffaele Chiatto Produced"

' Query folder name.
path = InputBox("Inserisci il nome della cartella (Es. C:\Raffaele).", _
                Title, "C:\Raffaele")
If path = "" Then
    WScript.Quit         ' Canceled by the user.
End If

newpath = path          ' Save path (for deletion).

' Create FileSystemObject object to access file system.
Set fso = WScript.CreateObject("Scripting.FileSystemObject")

' Check whether the folder exists.
If (Not fso.FolderExists(path)) Then
    ' Folder doesn't exist; create it.
    Set oFolders = fso.CreateFolder(path)
    MsgBox "Folder " & path & " created"
    isnew = True        ' Keep in mind that the folder is new.
Else
    isnew = False       ' Keep in mind that the folder already exists.
End If

If (MsgBox("Lista delle Cartelle?", _
           vbYesNo + vbQuestion, Title) = vbYes) Then
    ' Fetch parent folder.
    parent = fso.GetParentFolderName(path)
 
    If (parent = "") Then
        MsgBox "No parent folder"
    Else
        ' Get Folders collection.
        Set oFolders = fso.GetFolder(parent)  
        Set oSubFolder = oFolders.SubFolders

        For Each oFolder In oSubFolder          ' All folders
            Text = Text & oFolder.Name & vbCrLf
        Next

        MsgBox Text, vbOKOnly + vbInformation, Title
    End If
End If

If isnew = False Then
    MsgBox "Attention! The next steps might delete your folder " & _
           newpath & vbCrLf & _
           "Do not delete system folders!", _
           vbYes + vbExclamation, Title
End If 

' Rename folder using the MoveFolder method.
If (MsgBox("Rename folder " & path & " ?", _
           vbYesNo + vbQuestion, Title) = vbYes) Then
    ' Yes, the user agrees.
    newpath = path & "New"
    fso.MoveFolder path, newpath

    MsgBox "Folder renamed " & newpath
End If

' Delete folder.
If (MsgBox("Delete folder " & newpath & " ?", _
           vbYesNo + vbQuestion, Title) = vbYes) Then
    ' User has accepted.
    fso.DeleteFolder(newpath)
End If 

'*** End